## -*-Tcl-*-
 # ==========================================================================
 #  Help Files
 # 
 #  FILE: "Quick Start.tcl"
 #                                    created: 00-10-30 12.38.57 
 #                                last update: 00-12-14 20.01.46 
 #  Description: 
 #  
 #  Script to open the Quick Start url in a browser from Alpha's Help menu.
 #  
 #  Donavan Hall has created an Alpha support web site which includes a
 #  FAQ, some Quick Start items, tutorials, and other goodies useful for
 #  both new users and Alpha developers.
 #  
 #  The preference "alphaHelpUrl" can set the base url for this site, in
 #  case it is mirrored elsewhere.  Note that we don't pay attention to the
 #  "helpMenuOptions" variable, because the html file is a remote link
 #  rather than a local page -- the content is also different, so we give
 #  users the explicit option whenever "Quick Start" is selected.
 # 
 #  Author: Craig Barton Upright
 #  E-mail: <cupright@princeton.edu>
 #    mail: Princeton University, Department of Sociology
 #          Princeton, New Jersey 08544
 #     www: <http://www.princeton.edu/~cupright>
 #  
 # ==========================================================================
 ##

if {![info exists alphaHelpUrl] || $alphaHelpUrl == ""} {
    set alphaHelpUrl "http://magnet.fsu.edu/~hall/docscripting/alpha/"
} 

set options [list \
  "Open Quick Start file" \
  "Open Quick Start www link" \
  ]
#set option [listpick -p "Quick Start options " $options]

if {1 || $option == "Open Quick Start file"} {
    help::openDirect "Quick Start"
} else {
    url::execute ${alphaHelpUrl}manual/quickstart/index.html
} 
